@REM All steps for generating snobol5 version of Personal Editor 3
@REM Execute once: vcvars64.bat wherever it is, once for command prompt session
@REM Execute once: set include=%include%;.
@REM Execute once: set LIBPATH=.;%LIBPATH%
@REM have the snobol5.exe in the path somewhere other than this directory
@REM unzip s5source.zip first and then unzip pe3source.zip over it, in your windows build directory
@rem use Ubuntu 22.04 or later for the linux compile
@rem On your linux machine: apt-get install gcc                version (4:11.2.0-1ubuntu1) or later
@rem On your linux machine: apt-get install libncurses5-dev    version (6.3-2ubuntu0.1) or later
@rem On your linux machine: apt-get install libtinfo6          version (6.3-2ubuntu0.1) or later
@rem On your linux machine: apt-get install binutils           version (2.38-4ubuntu2.2) or later

@REM set these to the login@address and the build path of your Linux machine, before running this script
@REM set linuxmachine=yourid@yourmachine
@REM set linuxpath=x/

@if exist snobol5.obj erase /Q snobol5.obj
@if exist snobol5.o erase /Q snobol5.o
@if exist pe3ncur.o /Q pe3ncur.o
@copy /Y pe3ncur.c pe3cur.c
@scp pe3cur.c %linuxmachine%:%linuxpath%/.
@copy /Y keydefs.lnx keydefs.inc
@call gens5.cmd custom
@snobol5 setversion.sno -7 pe3version.inc
@snobol5 encode.sno -1 pe3.sno -i

ml64 /Sa /Fl /Dpe3 /c -DX64 /Dlinuxenvironment /Dcustomaddon /c snobol5.asm
scp snobol5.obj %linuxmachine%:%linuxpath%/.
SSH %linuxmachine% "objcopy %linuxpath%/snobol5.obj %linuxpath%/snobol5.o"

rem on linux:
rem               gcc -static pe3cur.c snobol5.o -o pe3 -lncurses -ltinfo
SSH %linuxmachine% "gcc -static %linuxpath%/pe3cur.c %linuxpath%/snobol5.o -o %linuxpath%/pe3 -lncurses -ltinfo"
