* command parsing setup:

* typical parameter patterns for commands:
        fnamep = spannot("#%&{}[]<>*?!+`|")
+              | "'" spannot("#%&{}[]<>*?!+`|'") "'"
+              | '"' spannot('#%&{}[]<>*?!+`|"') '"'
        tabsnotabs = 'tabs' | 'notabs' | ''
        keybdname = span(&lc &DIG '-')
        optnumberparam = (ws @paramstrt sd | @paramstrt)
        numberparam = (ws @paramstrt sd)
        allparam = (ws @paramstrt2 REM @paramend2)
*       allparamht = ((' ' | '') @paramstrt MAXARB)
*       allparamht = ((aws | '') @paramstrt REM @paramend2)
        allparamht = ((aws | '') @paramstrt (rtab(1) @paramend2 break(']') | REM @paramend2))
        allparamdos = ((' ' | '') @paramstrt MAXARB)
        onoffparam = (ws @paramstrt 'on' | ws @paramstrt 'off')
        anyexactparam = (ws @paramstrt 'any' | ws @paramstrt 'exact')
        maxarbnotabs = ws sd *maxarbnotabs | ''
        tabsparam = (ws @paramstrt (sd maxarbnotabs | 'every' ws sd ws 'starting' ws sd))
        filenameparam = (ws @paramstrt fnamep)
        optfilenameparam = (ws @paramstrt fnamep | @paramstrt '')
        editparams = ((ws @paramstrt fnamep (sob 'notabs' | sob 'tabs' | '') | @paramstrt ''))
        keynameparam = (ws @paramstrt keybdname)
        renameparam = (ws @paramstrt fnamep) (sob @paramstrt2 fnamep)
        stringparam1 = (@paramstrt *reduce(.paramstrt) break('"') '"')
        stringparam2 = (@paramstrt *reduce(.paramstrt) break("'") "'")
        marginsparam = (ws @paramstrt sd ws sd (ws sd | ''))
        keydefpat = (ws @paramstrt keybdname ws sd)
        varname = sob span(&lc)
        varop = sob any('+-*/')
        varterm = sob sd | sob varname | sob '(' *varexp sob ')'
        varexp = varterm varop *varexp | varterm
        varparam = (ws @paramstrt varname sob '=' sob varexp sob)
        testparam = (ws @paramstrt varexp sob ('<' | '>' | '=' | '<=' | '>=' | '~=' | '!=') sob varexp ws keybdname)
        putvarparam = (ws @paramstrt varname)

* change command parameters:
        changeparam = (sob @paramstrt LEN(1) $ qt @searchsts *break(qt)  @searchste *qt @replacests *break(qt) . replacest @replaceste *qt (span(',-m*') | '') . mods)

* locate command parameters:
        locslashparam = (@paramstrt (@searchsts break('/') @searchste '/' (span('m-') | '') . mods
+                                 |  @searchsts  spannot('/') @searchste '' . mods))
        locateparam = (sob @paramstrt (LEN(1) $ qt @searchsts *break(qt)    @searchste *qt (span('-m') | '') . mods)
+                                   | ('/'         @searchsts  spannot('/') @searchste                   ''  . mods))

* define command parameters:
        maxarbnocmd = sob *commandpat *maxarbnocmd | ''
        defineparam = (ws @paramstrt keybdname $ keyadd *defkeyadd() sob '=' sob @paramstrtdef maxarbnocmd @paramenddef *defkeytail())
        firstcmdpat = @firstcmdstrt *commandpat @firstcmdend *maxarbnocmd

* build commandpat pattern: (order of calls is important)
* cmdname(short name,long name,brackets,pattern)
*  brackets = 0 for must have brackets []
*  brackets = 1 for brackets optional []
*  brackets = 2 for brackets never (no cases currently####)
*  brackets = 3 for brackets optional only for long name, must have brackets [] for short name
* variable "cmdl_xx" contains long name of command short name xx
* variable "cmds_xxxxx" contains short name of short or long command xxxxx

* Can specify a character code as 3 digit decimal: [050] = '2'
 commandpat = ('[' @cmdnamestrt span(&DIG) $ cmd *lt(cmd,256) *eq(size(cmd),3) @cmdnameend @finalpend ']' *setcode(cmd) @finalend *smlg)

 cmdname('ht','helptext',1,allparamht)
 cmdname('snol','snolocate',1,allparamht)
 cmdname('snoc','snochange',1,allparamht)
 cmdname('dos','dos',1,allparamht)
 cmdname('dos','system',1,allparamht)
 cmdname('keydef','keydef',1,keydefpat)
 cmdname('here','here',1,keynameparam)
 cmdname('msg','msg',1,allparamht)
 cmdname('"','"',1,stringparam1)
 cmdname("'","'",1,stringparam2)
 cmdname('bw','backtab word',3)
 cmdname('bt','backtab',3)
*cmdname('bp','beep')
 cmdname('bl','begin line',3)
 cmdname('bm','begin mark',3)
 cmdname('wb','begin word',3)
 cmdname('be','bottom edge',3)
 cmdname('bo','bottom',3)
 cmdname('ci','center in margins',0)
 cmdname('ck','clear marks',0)
 cmdname('cl','center line',0)
 cmdname('ce','clear message',0)
*cmdname('chd','chdir',0,optfilenameparam)
 cmdname('col','column',0,optnumberparam)
 cmdname('cg','command toggle',0)
 cmdname('cf','copy from command',0)
 cmdname('cm','copy mark',0)
 cmdname('ct','copy to command',0)
 cmdname('co','confirm change',0)
 cmdname('cc','cursor command',0)
 cmdname('ca','cursor data',0)
 cmdname('c','change',1,changeparam)
 cmdname('date','date',1)
 cmdname('dc','delete char',3)
 cmdname('dl','delete line',3)
 cmdname('dm','delete mark',3)
 cmdname('de','demo end',3)
 cmdname('df','demo fast',3)
 cmdname('ds','demo slow',3)
 cmdname('dir','dir',1,optfilenameparam)
 cmdname('dn','down',3,optnumberparam)
 cmdname('d','define',1,defineparam)
 cmdname('d','def',1,defineparam)
 cmdname('el','end line',3)
 cmdname('em','end mark',3)
 cmdname('we','end word',3)
 cmdname('eb','erase begin line',0)
 cmdname('ee','erase end line',0)
*cmdname('es','escape')
 cmdname('ex','execute',3)
*cmdname('ef','erase',1,filenameparam)
 cmdname('fl','file',3,editparams)
 cmdname('fm','fill mark',3)
 cmdname('fb','find blank line',3)
 cmdname('fn','first nonblank',3)
 cmdname('fp','find prior blank line',3)
 cmdname('help','help',1)
 cmdname('in','indent',3)
 cmdname('il','insert line',3)
 cmdname('im','insert mode',3)
 cmdname('it','insert toggle',3)
 cmdname('jo','join',3)
 cmdname('key','key',1,keynameparam)
 cmdname('le','left edge',0)
 cmdname('lg','left margin',0)
 cmdname('lf','left',1,optnumberparam)
 cmdname('ln','line',3,optnumberparam)
 cmdname('lc','lowercase',0)
 cmdname('l','locate',1,locateparam)
 cmdname('/','/',1,locslashparam)
 cmdname('m','macro',1,filenameparam)
 cmdname('mb','mark block',3)
 cmdname('mc','mark char',3)
 cmdname('ml','mark line',3)
 cmdname('mm','move mark',3)
 cmdname('nest','nest',1)
 cmdname('nm','name',1,filenameparam)
 cmdname('nv','next view',3)
 cmdname('nw','next window',3)
 cmdname('ob','overlay block',3)
 cmdname('ps','push mark',3)
 cmdname('pd','page down',3)
 cmdname('pu','page up',3)
 cmdname('pg','paragraph margin',3)
 cmdname('po','pop mark',3)
*cmdname('pm','print mark',3)
*cmdname('pr','print',3)
 cmdname('pv','putvar',1,putvarparam)
 cmdname('pe3','edit',1,editparams)
 cmdname('p','edit',1,editparams)
 cmdname('e','edit',1,editparams)
 cmdname('q','quit',1)
 cmdname('rc','repeat change',1)
 cmdname('rf','reflow',3)
*cmdname('rn','rename',3,renameparam)
 cmdname('rl','repeat locate',1)
 cmdname('rm','replace mode',3)
 cmdname('re','right edge',0)
 cmdname('rg','right margin',0)
 cmdname('rt','right',3,optnumberparam)
 cmdname('ro','rubout',3)
 cmdname('sv','save',3,editparams)
 cmdname('scd','scrolldown',1,optnumberparam)
 cmdname('scl','scrollleft',1,optnumberparam)
 cmdname('scu','scrollup',1,optnumberparam)
 cmdname('scr','scrollright',1,optnumberparam)
 cmdname('sta','s abbrev',1,onoffparam)
 cmdname('stf','s confirm',1,onoffparam)
 cmdname('stk','s backup',1,numberparam)
 cmdname('stb','s blankcompress',1,onoffparam)
 cmdname('stc','s carriagereturn',1,onoffparam)
* cmdname('stp','s display',1,allparam)
 cmdname('sth','s hscroll',1,onoffparam)
 cmdname('stm','s margins',1,marginsparam)
 cmdname('sto','s mouse',1,onoffparam)
 cmdname('sts','s searchcase',1,anyexactparam)
 cmdname('ste','s tabexpand',1,onoffparam)
 cmdname('stt','s tabs',1,tabsparam)
 cmdname('sta','set abbrev',1,onoffparam)
 cmdname('stk','set backup',1,numberparam)
 cmdname('stb','set blankcompress',1,onoffparam)
 cmdname('stc','set carriagereturn',1,onoffparam)
 cmdname('stf','set confirm',1,onoffparam)
* cmdname('stp','set display',1,allparam)
 cmdname('sth','set hscroll',1,onoffparam)
 cmdname('stm','set margins',1,marginsparam)
 cmdname('sto','set mouse',1,onoffparam)
 cmdname('sts','set searchcase',1,anyexactparam)
 cmdname('ste','set tabexpand',1,onoffparam)
 cmdname('stt','set tabs',1,tabsparam)
 cmdname('sl','shift left',3)
 cmdname('sort','sort',1)
 cmdname('sum','sum',1)
 cmdname('sr','shift right',3)
 cmdname('ss','split screen',3)
 cmdname('sp','split',3)
 cmdname('tw','tab word',3)
 cmdname('tb','tab',3)
 cmdname('test','test',1,testparam)
 cmdname('te','top edge',3)
 cmdname('to','top',3)
 cmdname('ud','undo',3)
 cmdname('um','unmark',3)
 cmdname('uc','uppercase',3)
 cmdname('up','up',1,optnumberparam)
 cmdname('var','var',0,varparam)
 cmdname('version','version',1)
 cmdname('zw','zoom window',3)
 cmdname('?a','? abbrev',1)
 cmdname('?k','? backup',1)
 cmdname('?b','? blankcompress',1)
 cmdname('?cr','? carriagereturn',1)
 cmdname('?c','? char',1)
 cmdname('?f','? confirm',1)
*cmdname('?dir','? dir',1)
*cmdname('?fr','? diskspace',1)
 cmdname('?h','? hscroll',1)
 cmdname('?key','? key',1,keynameparam)
 cmdname('?m','? margins',1)
 cmdname('?o','? mouse',1)
 cmdname('?y','? memory',1)
 cmdname('?s','? searchcase',1)
 cmdname('?e','? tabexpand',1)
 cmdname('?t','? tabs',1)

