ht Personal Editor 3
ht
ht This	is a text editor written from scratch using the	Snobol5	language.
ht The author is Viktors Berstis and the open source is	at snobol5.org.
ht There is no warranty, no merchantability and	no fitness for any purpose.
ht It is highly	compatible with	the IBM	Personal Editors I and II.
ht PE3 runs on 64bit Intel Windows and Linux machines.
ht The editor is invoked specifying any	number of files	to edit	at once:
ht    pe3  <filename <filename ...>>
ht The "PE3" environment variable can point to a profile file which can
ht redefine the	functions of all of the	keyboard keys as desired.
ht The file pe3keys.pro	is the default profile which also contains this	help.
ht The %TEMP% directory	in Windows and /tmp directory in Linux
ht receives a backup copy of the file(s) opened	in case	of any problem.
ht Those directories also contain a "script.pe3..." file along with the	backup(s).
ht The script file logs	all commands executed in the edit session
ht (unless backup is set to zero) and the script can be	replayed
ht against the original	backup file to achieve the same	result.
ht The last command causing the	problem	can be removed from the	script.
ht In case of any remaining editor bug,	please find these files
ht and save them as they will enable reproducing any bug so that
ht it can be fixed. The	editor keeps all information in	memory.
ht If the files	being edited are large,	you can	specify	a larger
ht allocation when invoking pe3:
ht	pe3 <filename <filename	...>> --work=nnnM
ht where "nnn" is a number, "M"	stands for megabytes while you can
ht also	use "G"	for gigabyes. Any editor commands can be entered
ht on the green	command	line near the bottom. A	mouse click can
ht move	the cursor to a	particular spot	and drag to create a character
ht mark	with the left button or	block mark with	the right button.
ht [set	mouse off] to enable normal system mouse and clipboard actions.
ht Note	that on	Linux the Esc key seems	to be implemented with a
ht delay, possibly waiting for a second	key to be pressed.
ht You may want	to assign the data/command toggle to a different key.
ht Most	keys are available on both Windows and Linux but there
ht are some differences. See source keydefs.win	and keydefs.lnx	files.
ht Let Viktors know if your keyboard responds differently.
ht Any of the key names	can be assigned	commands and invoked with the key command.
ht There are many of the form u-x which	are user defined and have no
ht keyboard equivalent,	but can	be invoked with	the key	command.
ht A more complete description of PE3 and all of the commands
ht is in a separate file called	"####to	be written".
ht In the meantime http://snobol5.org/pe2doc.htm may be	useful.
ht
ht Further below is a list of the implemented commands.
ht The following documents the default PE3 key assignments and functions
ht if no alternate profile was specified:
ht
ht up arrow = move cursor up one line
define up = [up]
ht down	arrow =	move cursor down one line
define down = [down]
ht left	arrow =	move cursor one	character to the left
define left = [left]
ht right arrow = move cursor one character to the right
define right = [right]
ht PgUp	= scroll up one	page toward the	front of the file
define pgup = [page up]
ht PgDn	= scroll down one page toward the bottom of the	file
define pgdn = [page down]
ht Home	= move cursor to the start of the line
define home = [begin line]
ht End = move cursor to	the end	of the line
define end = [end line]
ht Insert = change to insert mode when typing characters
define ins = [insert toggle]
ht Delete = delete a character at the cursor position
define del = [delete char]
ht Enter = moves cursor	down one line to indent	position
define enter = [begin line] [down] [indent]
ht Backspace = deletes a character before the cursor position
define backspace = [rubout]
ht Esc = toggles between the command line and data area
define esc = [command toggle]
ht tab = moves the cursor to the next tab spot
define tab = [tab]
ht characters =	enter the corresponding	keyboard character at the cursor position
define a = 'a'
define b = 'b'
define c = 'c'
define d = 'd'
define e = 'e'
define f = 'f'
define g = 'g'
define h = 'h'
define i = 'i'
define j = 'j'
define k = 'k'
define l = 'l'
define m = 'm'
define n = 'n'
define o = 'o'
define p = 'p'
define q = 'q'
define r = 'r'
define s = 's'
define t = 't'
define u = 'u'
define v = 'v'
define w = 'w'
define x = 'x'
define y = 'y'
define z = 'z'
define 0 = '0'
define 1 = '1'
define 2 = '2'
define 3 = '3'
define 4 = '4'
define 5 = '5'
define 6 = '6'
define 7 = '7'
define 8 = '8'
define 9 = '9'
define s-a = 'A'
define s-b = 'B'
define s-c = 'C'
define s-d = 'D'
define s-e = 'E'
define s-f = 'F'
define s-g = 'G'
define s-h = 'H'
define s-i = 'I'
define s-j = 'J'
define s-k = 'K'
define s-l = 'L'
define s-m = 'M'
define s-n = 'N'
define s-o = 'O'
define s-p = 'P'
define s-q = 'Q'
define s-r = 'R'
define s-s = 'S'
define s-t = 'T'
define s-u = 'U'
define s-v = 'V'
define s-w = 'W'
define s-x = 'X'
define s-y = 'Y'
define s-z = 'Z'
define s-0 = ')'
define s-1 = '!'
define s-2 = '@'
define s-3 = '#'
define s-4 = '$'
define s-5 = '%'
define s-6 = '^'
define s-7 = '&'
define s-8 = '*'
define s-9 = '('
define s-minus = '_'
define s-equals	= '+'
define s-lbracket = '{'
define s-rbracket = '}'
define s-semi =	':'
define s-quote = '"'
define s-backquote = '~'
define s-comma = '<'
define s-period	= '>'
define s-slash = '?'
define s-backslash = '|'
define s-pad5 =	'5'
define minus = '-'
define equals =	'='
define lbracket	= '['
define rbracket	= ']'
define semi = ';'
define quote = "'"
define backquote = '`'
define comma = ','
define period =	'.'
define slash = '/'
define backslash = '\'
define padplus = '+'
define padminus	= '-'
define padstar = '*'
define padslash	= '/'
define space = ' '
ht F1 =	show this help info
define f1 = [help]
ht F2 =	to save	the current file to disk
define f2 = [save]
ht F3 =	to save	the current file and quit editing it
define f3 = [file]
ht F4 =	quit editing the current file
define f4 = [quit]
ht F5 =	repeat the command on the green	command	line
define f5= [cursor command] [execute]
ht F6 =	confirm	a change command
define f6=[confirm change]
ht F8 =	switch to editing the next file
define f8 = [edit]
ht F9 =	insert a new line below	the cursor line	and set	cursor to column 1
define f9 = [insert line]
ht F10 = insert	a line and move	cursor under the first non blank of the	prior line
define f10= [insert line][up][first nonblank][down]
ht Alt-F10 = insert a line above the cursor line and move cursor to first non blank above current line
define a-f10=[begin line][split][down][first nonblank][up]
ht F11 = move to next window when split	into multiple panes
define f11 = [next window]
ht F12 = change	character at cursor to lower case
define f12 = [push mark][mark char][lowercase][right][pop mark]
ht Ctrl-Up arrow = shift everything in block mark up one line
define c-up=[begin mark][zoom window][split screen][split screen][bottom][insert line][begin mark][bottom][overlay block][next view][bottom][insert line][end mark][bottom][push mark][mark block][next	view][next view][next view][down][mark block][next view][next view][overlay block][next	view][next view][unmark][up][mark line][bottom][mark line][delete mark][next view][next	view][zoom window][pop mark][begin line]
ht Ctrl-Down arrow = shift everything in block mark down one line
define c-down=[begin mark][zoom	window][split screen][split screen][bottom][insert line][insert	line][begin mark][bottom][overlay block][up][next view][end mark][bottom][delete line][push mark][mark block][next view][next view][next view][mark block][next	view][next view][overlay block][next view][next	view][unmark][mark line][bottom][mark line][delete mark][next view][next view][zoom window][pop	mark][begin line]
ht Ctrl-Left arrow = shift everything in block mark left one character
define c-left=[begin mark][zoom	window][split screen][split screen][bottom][insert line][begin mark][bottom][overlay block][next view][end mark][bottom][push mark][right][mark	block][next view][next view][next view][right][mark block][next	view][next view][overlay block][next view][next	view][unmark][mark line][bottom][mark line][delete mark][next view][next view][zoom window][pop	mark][begin line]
ht Ctrl-Right arrow = shift everything in block	mark right one character
define c-right=[begin mark][zoom window][split screen][split screen][bottom][insert line][begin	mark][bottom][overlay block][next view][end mark][bottom][fill mark][' '][push mark][left][mark	block][next view][next view][next view][mark block][next view][next view][right][overlay block][next view][next	view][unmark][mark line][bottom][mark line][delete mark][next view][next view][zoom window][pop	mark][begin line]
ht Ctrl-PgUp = move cursor to top edge of data window
define c-pgup =	[top edge]
ht Ctrl-PgDn = move cursor to bottom edge of data window
define c-pgdn =	[bottom	edge]
ht Ctrl-Home = move cursor to first line in the	file
define c-home =	[top]
ht Ctrl-End = move cursor to the last line in the file
define c-end = [bottom]
ht Ctrl-Delete = erase from the	cursor to the end of the line
define c-del = [erase end line]
ht Alt-Delete =	erase from the cursor to the beginning of the line
define a-del = [erase begin line] [begin line]
ht Ctrl-Backspace = delete the cursor line
define c-backspace = [delete line]
ht Ctrl-b = move cursor	to beginning of	a word
define c-b = [begin word]
ht Ctrl-e = move cursor	to the end of a	word
define c-e = [end word]
ht Ctrl-f = copy the command line to the data area
define c-f = [copy from	command]
ht Ctrl-j = Join the next line to the cursor line and move cursor to join point
define c-j = [end line]	[join]
ht Ctrl-k = edit the .keydefs file of current key definitions
define c-k = [edit .keydefs]
ht Ctrl-l = move cursor	line to	center of data window
define c-l = [center line]
ht Ctrl-o = pop	current	mark off of stack and restore prior mark if any
define c-o = [pop mark]
ht Ctrl-p = push the current mark onto the mark	stack and allow	a new mark
define c-p = [push mark]
ht Ctrl-r = duplicate the cursor line
define c-r = [push mark] [mark line] [copy mark] [pop mark]
ht Ctrl-s = split the screen to	allow simultaneous views of the	same of	different files
define c-s = [split screen]
ht Ctrl-t = copy cursor	line to	the command line
define c-t = [copy to command]
ht Ctrl-u = edit .unnamed containing lines before they were changed
define c-u = [edit .unnamed]
ht Ctrl-V = move to the	next split window containing the same file
define c-v = [next view]
ht Ctrl-w = move to the	next split window
define c-w = [next window]
ht Ctrl-z = zoom to make the current split window full size and	single
define c-z = [zoom window]
ht Ctrl-F1 = Turn off PE3 mouse, revert	to system mouse
define c-f1 = [set mouse off]
ht Ctrl-F2 = Turn on PE3 mouse support,	no system mouse
define c-f2 = [set mouse on]
ht Shift-up arrow = '8'
define s-up = '8'
ht Shift-down arrow = '2'
define s-down =	'2'
ht Shift-left arrow = '4'
define s-left =	'4'
ht Shift-right = '6'
define s-right = '6'
ht Shift-PgUp =	'9'
define s-pgup =	'9'
ht Shift-PgDn =	'3'
define s-pgdn =	'3'
ht Shift-Home =	'7'
define s-home =	'7'
ht Shift-End = '1'
define s-end = '1'
ht Shift-Insert	= '0'
define s-ins = '0'
ht Shift-del = '.'
define s-del = '.'
ht Shift-Tab = move cursor one tab to the left
define s-tab = [backtab]
ht Shift-F3 = reflow marked lines per margins setting
define s-f3 = [reflow]
ht Shift-F4 = Limited undo of line if you have not moved off of	it
define s-f4 = [undo]
ht Shift-F7 = shifts marked area one character to the left
define s-f7 = [shift left]
ht Shift-F8 = shifts marked area one character to the right
define s-f8 = [shift right]
ht Shift-F12 = change character	at cursor to UPPER case
define s-f12 = [push mark][mark	char][uppercase][right][pop mark]
ht Alt-b = to mark the start and end of	a block
define a-b = [mark block]
ht Alt-c = to mark the start and end of	characters range
define a-c = [mark char]
ht Alt-d = delete a marked area
define a-d = [delete mark]
ht Alt-e = move	cursor to the end of a marked area
define a-e = [end mark]
ht Alt-f = fill	the marked area	with the next character	typed
define a-f = [fill mark]
ht Alt-i = hold	down this combination to invert	the order of lines in a	line mark area
d a-i=[key u-l][cc][bl][ee][bm][ct][em][cf][bm][ca][dl][cc][bl][ee]
d u-l=[d up=[up]][d down=[down]][d left=[left]][d right=[right]][d a-l=[ml][d up=[up][ml]][d down=[down][ml]][d	a-l=[ml][key u-l]]][key	u-m]
d u-m=[d a-b=[mb][d up=[up][mb]][d down=[down][mb]][d left=[left][mb]][d right=[right][mb]][d a-b=[key u-l]]][d	a-c=[mc][d up=[up][mc]][d down=[down][mc]][d left=[left][mc]][d	right=[right][mc]][d a-c=[key u-l]]]
ht Alt-j = Join	the next line with the cursor line
define a-j = [end line][join]
ht Alt-l = to mark the start and end of	a range	of lines
define a-l = [mark line]
ht Alt-m = move	a marked area to the cursor position
define a-m = [move mark]
ht Alt-n = push	any current mark and create a marked area showing nesting above	the cursor line
define a-n = [nest]
ht Alt-o = overlay the marked block at the cursor position
define a-o = [overlay block]
ht Alt-p = reflow next paragraph according to margin settings
define a-p = [cursor data] [push mark] [mark line] [bottom] [insert line] [begin mark] [find blank line] [up] [mark line] [reflow] [bottom] [delete line] [end mark] [up 20] [end mark]	[down 11] [end mark] [down 2] [first nonblank] [pop mark]
ht Alt-s = split the line at the cursor	position
define a-s = [split]
ht Alt-u = unmark a marked area
define a-u = [unmark]
ht Alt-w = character mark next word
define a-w = [unmark] [tab word] [mark char] [end word]	[right]	[mark char] [begin mark]
ht Alt-y = move	cursor to beginning of a marked	area
define a-y = [begin mark]
ht Alt-z = copy	a marked area to the cursor position
define a-z = [copy mark]
ht Alt-F1 = show how much memmory is still available #### not implemented yet
define a-f1 = [? memory]
ht Alt-F2 = show current mouse setting
define a-f2 = [? mouse]
ht Alt-F4 = show horizontal scroll setting
define a-f4 = [? hscroll]
ht Alt-F5 = show the current tabs setting
define a-f5 = [? tabs]
ht Alt-F6 = show the current margins setting
define a-f6 = [? margins]
ht Alt-F7 = show current tabs expand setting when reading files
define a-f7 = [? tabexpand]
ht Alt-F8 = show blankcompress setting when writing files
define a-f8 = [? blankcompress]
ht Alt-F9 = show search	case setting
define a-f9 = [? searchcase]
ht Alt-minus = back tab	one word
define a-minus = [backtab word]
ht Alt-equals =	forward	tab one	word
define a-equals	= [tab word]
ht Alt-quote = ditto the character from	the line above the cursor
define a-quote = [push mark][' '][left][up][mark block][down][overlay block][right][pop	mark]
ht
ht Implemented commands:
ht [date] write	date/time at cursor location
ht [help] show this help text
ht [helptext] add a line of help text
ht [key	keyname] executes commands defined for keyname
ht [/searchstring] search for searchstring
ht [nest] create marked	lines above current line showing nesting
ht [sort] sort the lines of the	block mark according to	marked content
ht [sum] insert	a line summing the blocked mark	content
ht [up n] move up one or n lines
ht [?key keyname] show command(s) assigned to keyname
ht ["string"] or "string" type the string at the cursor	position
ht [nnn] where nnn is 0	to 255 types the corresponding character code
ht Holding Shift+Alt while typing 3 digits (0-255) types the character code
ht [?a]	or [? abbrev] show command abbreviation	setting
ht [?k]	or [? backup] show backup setting
ht [?b]	or [? blankcompress] show blankcompress	on file	save
ht [?c]	or [? char] show decimal character code	of character at	cursor
ht [?h]	or [? hscroll] show hscroll setting
ht [?m]	or [? margins] show margins setting
ht [?y]	or [? memory] show remaining memory bytes quantity
ht [?s]	or [? searchcase] show search case
ht [?e]	or [? tabexpand] show tabexpand	for reading a file
ht [?t]	or [? tabs] show tab points
ht [bw]	or [backtab word] tab to prior word
ht [bt]	or [backtab] tab to prior tab point
ht [bl]	or [begin line]	move cursor to start of	line
ht [bm]	or [begin mark]	move cursor to start of	marked area
ht [wb]	or [begin word]	move cursor to start of	word
ht [be]	or [bottom edge] move cursor to	bottom edge of data display
ht [bo]	or [bottom] move cursor	to last	line in	the file
ht [ci]	or [center in margins] center line per margins setting
ht [cl]	or [center line] scroll	data pane to put cursors line in center	of pane
ht [c] or [change/string1/string2/*-m] search for string1 and replace it with
ht	       string2.	* do all lines,	- to search backward, m	to only	search in marked area
ht [ck]	or [clear marks] get rid of all	marks
ht [ce]	or [clear message] erase the red message
ht [col] or [column n] move cursor to column n
ht [cg]	or [command toggle] toggle cursor between data pane and	green command line
ht [co]	or [confirm change] confirm a change command when not using *
ht [cf]	or [copy from command] copy the	command	line area to a new line	under the cursor
ht [cm]	or [copy mark] copy marked area	to cursor position
ht [ct]	or [copy to command] copy a data line to the command line
ht [cc]	or [cursor command] move cursor	to the command line
ht [ca]	or [cursor data] move cursor to	the data pane
ht [d]	or [def] or [define keyname = cmds] program keyname to execute commands	cmds when struck
ht [dc]	or [delete char] delete	character at the cursor
ht [dl]	or [delete line] delete	the cursor line
ht [dm]	or [delete mark] delete	a marked area
ht [dn]	or [down n] move cursor	down one or n lines
ht [el]	or [end	line] move cursor to the end of	the line
ht [em]	or [end	mark] move cursor to the end of	the marked area
ht [we]	or [end	word] move cursor to the end of	word
ht [eb]	or [erase begin	line] erase from cursor	to start of line
ht [ee]	or [erase end line] erase from cursor to end of	line
ht [ex]	or [execute] execute command(s)	in the green command line area
ht [fl]	or [file] save the file	to disk	and end	editing	this file
ht [fm]	or [fill mark] fill the	marked area with the following character typed
ht [fb]	or [find blank line] find the next blank line
ht [fn]	or [first nonblank] move cursor	to the first non-blank on the line
ht [ht]	or [helptext] add a line to the	help text (useful in profiles)
ht [in]	or [indent] moves cursor to paragraph margin or	left margin per	margin settings
ht [il]	or [insert line] insert	a new line below cursor	line
ht [im]	or [insert mode] change	to insert mode when typing
ht [it]	or [insert toggle] toggle between insert and replace mode
ht [jo]	or [join] join the cursor line with the	next one
ht [le]	or [left edge] move cursor to left edge	of data	pane
ht [lg]	or [left margin] move cursor to	the left margin	per margin settings
ht [lf]	or [left n] move cursor	left one or n characters
ht [ln]	or [line n] move cursor	to line	number n
ht [l]	or [locate/string/m-] search for string. m for only in marked area
ht	       - for toward the	beginning of the file
ht [lc]	or [lowercase] convert charcters in the	marked area to lower case
ht [m]	or [macro filename] execute commands in	file filename (e.g. to set a new profile)
ht [mb]	or [mark block]	mark a rectangular block start and end
ht [mc]	or [mark char] create a	character mark start and end
ht [ml]	or [mark line] create a	line mark start	and end
ht [mm]	or [move mark] move the	marked area to the cursor position
ht [nm]	or [name filename] use filename	when saving current file
ht [nv]	or [next view] move to next data pane editing the same file
ht [nw]	or [next window] move to the next data pane
ht [ob]	or [overlay block] overlay the marked block at the cursor position
ht [pd]	or [page down] scroll down one page
ht [pu]	or [page up] scroll up one page
ht [pg]	or [paragraph margin] move cursor to paragraph margin setting
ht [e]	or [pe3] or [edit filename] edit filename, if no filename, edit	next file opened.
ht [po]	or [pop	mark] restore previously pushed	mark area
ht [ps]	or [push mark] save current marked area	on a stack, to allow a new mark
ht [q]	or [quit] quit editing the current file
ht [rf]	or [reflow] reflow words per margins setting
ht [rm]	or [replace mode] change to replace mode (not insert mode)
ht [re]	or [right edge]	move to	right edge of data pane
ht [rg]	or [right margin] move cursor to right margin setting
ht [rt]	or [right n] move cursor right one or n	characters
ht [ro]	or [rubout] delete character before cursor
ht	       deletes character at cursor position if in column 1
ht [sta] or [s abbrev] or [set abbrev on/off] set command abbreviations	on or off when using ?k	or edit	.keydefs
ht [stk] or [s backup] or [set backup n] turn backup saving off	if n=0,
ht	    if n>0, create backup and script files in temp directory
ht	    if n>0 save	prior states of	lines from last	n edits	in .unnamed internal file
ht [stb] or [s blankcompress] or [set blankcompress on/off] sets whether blanks	should be compressed to	tabs on	save or	file
ht [sth] or [s hscroll]	or [set	hscroll	on/off]	if hscroll is on, left right pane scrolling is by single characters instead of half pane
ht [stm] or [s margins]	or [set	margins	l r p] set left	margin to l, right margin to r and paragraph margin to p
ht [sts] or [s searchcase] or [set searchcase any/exact] to set	whether	observe	alpha character	case on	locate and change searches
ht [ste] or [s tabexpand] or [set tabexpand on/off] to expand tabs into	blank when editing a file
ht [stt] or [s tabs] or	[set tabs every	n starting m] to set tab points	at m and every n characters thereafter
ht	    [set tabs n	n n n n	...] to	set points at columns n...
ht [sv]	or [save] save the current file	to disk
ht [scd] or [scrolldown	n] scroll data pane down one line or n lines
ht [scl] or [scrollleft	n] scroll data pane left one character or n characters
ht [scr] or [scrollright n] scroll data	pane right one character or n characters
ht [scu] or [scrollup n	] scroll data pane up one line or n lines
ht [sl]	or [shift left]	shifts text in marked area left	one character
ht [snol pattern] locates the next match after the cursor position, where "pattern" is a snobol5 pattern
ht [snoc pattern = replacement]	locates	and changes occurrentces where "pattern" matches in a line marked area
ht	   and replaces	the matches with replacement.  Only one	match per line is performed.
ht	   If you create an infinite loop, ctrl-break or Ctrl-c	will get you out, but without saving the file.
ht	   Preferably use only single letter variable names or the editor might	corrupt	further	edits.
ht [sr]	or [shift right] shifts	text in	marked area right one character
ht [ss]	or [split screen] splits screen	into up	to 4 data panes	to view	different parts	of the file or different files at once
ht [sp]	or [split] split the line into two lines at the	cursor position
ht [tw]	or [tab	word] move cursor to next word
ht [tb]	or [tab] move cursor to	next tab position
ht [te]	or [top	edge] move cursor to top edge of data pane
ht [to]	or [top] move cursor to	first line of the file
ht [ud]	or [undo] undo changes on a line if you	have not moved off of the line
ht [um]	or [unmark] remove the mark of an area
ht [uc]	or [uppercase] change alphabetic letters to upper case in the marked area
ht [zw]	or [zoom window] make the current data pane full window	size closing any other panes
msg Use	F1 for help
